-- freezing these disables button press ui at bottom of screen

freeze_addrs = {
    0x1A6140,
    0x1A697C,
    0x1AB078,
    0x1BC378,
    0x1BC398,
    0x1BC45C,
    0x1BC460
}

frozen_vals = {}
already_frozen = false

function main()
    -- client.SetVolume(00);
    -- client.pause()

    while true do
        should_freeze = emu.framecount() > 9999 -- hacky way of checking if we're in a scene other than the intro
        if (should_freeze) then
            if (already_frozen) then
                for i, addr in ipairs(freeze_addrs) do
                    memory.write_u32_le(addr, frozen_vals[addr])
                end
            else        
                for i, addr in ipairs(freeze_addrs) do
                    frozen_vals[addr] = memory.read_u32_le(addr)
                end
                already_frozen = true
            end
        end
        emu.frameadvance()
        -- print("Advance")
        
        joypad.set({
            ["X"] = false,
            -- ["○"] = false,
            -- ["□"] = false,
            -- ["△"] = false,
            ["Start"] = false,
            ["Select"] = false,
            ["Analog"] = false,
            ["L1"] = false,
            ["R1"] = false,
            ["L2"] = false,
            ["R2"] = false,
            ["D-Pad Down"] = false,
            ["D-Pad Up"] = false,
            ["D-Pad Left"] = false,
            ["D-Pad Right"] = false
        }, 1)
	end
end

main()